//=============================================================================

/*:
 * @plugindesc タッチ移動の仕様をなんとかする装置
 * 
 * @author LefTonbo
 *
 */

//=============================================================================

//=============================================================================

var Imported = Imported || {};
Imported.LP_FixTouchMovement = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// Game_Temp
//=============================================================================

var _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    this._isDestinationFar = -1;
};

Game_Temp.prototype.setDestinationFar = function(f) {
    this._isDestinationFar = f;
};

Game_Temp.prototype.destinationFar = function() {
    return this._isDestinationFar;
};

var _Game_Temp_setDestination = Game_Temp.prototype.setDestination;
Game_Temp.prototype.setDestination = function(x, y) {
    _Game_Temp_setDestination.call(this, x, y);
    this._isDestinationFar = -1;
};

//=============================================================================
// Game_Player
//=============================================================================

var _Game_Player_moveByInput = Game_Player.prototype.moveByInput;
Game_Player.prototype.moveByInput = function() {
  if (!this.isMoving() && this.canMove()) {
    if ($gameTemp.isDestinationValid()){
      if ($gameTemp.destinationFar() < 0) {
        var x = $gameTemp.destinationX();
        var y = $gameTemp.destinationY();
        var delta = Math.abs(this.deltaXFrom(x)) + Math.abs(this.deltaYFrom(y));
        if (delta >= 6) $gameTemp.setDestinationFar(1);
        else $gameTemp.setDestinationFar(0);
        this.updateDashing();
      }
    }
  }
  _Game_Player_moveByInput.call(this);
};

// 再定義
Game_Player.prototype.updateDashing = function() {
    if (this.isMoving()) {
        return;
    }
    if (this.canMove() && !this.isInVehicle() && !$gameMap.isDashDisabled()) {
        this._dashing = this.isDashButtonPressed() || ($gameTemp.isDestinationValid() && $gameTemp.destinationFar() > 0);
    } else {
        this._dashing = false;
    }
};

//=============================================================================

})();

// EOF